import es
import random
import gamethread
import playerlib

import wcs
from wcs import wcs

RaceName = 'Undead Scourge'
race = wcs.Race(RaceName)

""" Load the strings into the variable text """
text = race.loadStrings()

######################################
# Create Configs! (Must be done first)
config = race.config()
# Vampiric Aura
config.addComment('********************')
config.addComment('Vampiric Aura')
config.addComment('  Draw health from the damage that you inflict')
config.addComment('  to others.')
config.addComment('********************')
config.addComment()
vampiricMaxLevel      = config.addVar('vampiricMaxLevel',      5, 'The maximum level for the Vampiric Skill')
vampiricLevelInterval = config.addVar('vampiricLevelInterval', 2, 'The intervals between the abilities to upgrade their Vampiric skill')
vampiricPercent       = config.addVar('vampiricPercent',      10, 'This is the percent of health received in comparison to the damage, multiplied by the users level.')

# Unholy Aura
config.addComment()
config.addComment('********************')
config.addComment('Unholy Aura')
config.addComment('  This skill Gives you a speed boost upon spawn')
config.addComment('********************')
config.addComment()
unholyMaxLevel        = config.addVar('unholyMaxLevel',      4, 'The maximum level for the Unholy Aura skill')
unholyLevelInterval   = config.addVar('unholyLevelInterval', 3, 'The intervals between the abilities to upgrade their Unholy Aura skill')
unholyPercent         = config.addVar('unholyPercent',      10, 'The speed increase percentage per level') 

# Levitation
config.addComment()
config.addComment('********************')
config.addComment('Levitation')
config.addComment('  This skill Gives you a speed boost upon spawn')
config.addComment('********************')
config.addComment()
levMaxLevel           = config.addVar('levMaxLevel',      5, 'The maximum level for the Levitation skill')
levLevelInterval      = config.addVar('levLevelInterval', 1, 'The intervals between the abilities to upgrade their Levitation skill')
levPercent            = config.addVar('levPercent',      15, 'The gravity decrease percentage per level')

# Suicide Bomber
config.addComment()
config.addComment('********************')
config.addComment('Suicide Bomber')
config.addComment('  This ultimate allows you to power up yourself to') 
config.addComment('  run in as a kamikaze, blow yourself up and take') 
config.addComment('  out others.')
config.addComment('********************')
config.addComment()
bomberMaxLevel        = config.addVar('bomberMaxLevel',        4,  'The maximum level for the Suicide Bomber skill')
bomberMinLevel        = config.addVar('bomberMaxLevel',        8,  'The minimum level that this ultimate can be bought')
bomberLevelInterval   = config.addVar('bomberLevelInterval',   5,  'The interval between the skill upgrades')
bomberSuicideDamage   = config.addVar('bomberSuicideDamage',   10, 'This is the amount of damage done multiplied by the power and the level')
bomberSuicideDistance = config.addVar('bomberSuicideDistance', 20, 'This is the distance in game units (40 units = 1m) multiplied by the power and the level')

config.load(True)
# Load the file with server.cmd so it 
# loads instantly
########################################


race.registerSkill('Vampiric Aura', int(vampiricMaxLevel), int(vampiricLevelInterval), "Draw Health From the Damage you do to Others")
race.registerSkill("Unholy Aura",   int(unholyMaxLevel),   int(unholyLevelInterval),   "Speed Boost")
race.registerSkill("Levitation",    int(levMaxLevel),      int(levLevelInterval),      "Lower Gravity")

# Ultimate
race.registerUltimate("Suicide Bomber", int(bomberMinLevel), int(bomberMaxLevel), int(bomberLevelInterval), "Blow yourself up and damage nearbye enemies") 

def player_spawn(ev):
    userid = ev['userid']
    player = wcs.Command(userid)
    unholyLevel = wcs.GetLevel(userid, RaceName, 'Unholy Aura')
    if unholyLevel:
        plevel = unholyLevel * int(unholyPercent) * .01
        player.SpeedAdd(plevel)
        es.tell(userid, '#multi', text('unholy aura', {'speed': plevel * 100}, playerlib.getPlayer(userid).get("lang") ) )
    levLevel = wcs.GetLevel(userid, RaceName, 'Levitation')
    if levLevel:
        depth = 1 - levLevel * int(levPercent) * .01
        player.SetGravity(depth)
        es.tell(userid,'#multi', text('levitation', {'gravity': depth * 100}, playerlib.getPlayer(userid).get("lang") ) )

def player_hurt(ev):
    attacker = ev['attacker']
    userid   = ev['userid']
    dmg      = int(ev['dmg_health'])
    vampiric = wcs.GetLevel(attacker, RaceName, 'Vampiric Aura')
    if vampiric and userid != attacker:
        alpha = 60 + vampiric * 20
        x,y,z = es.getplayerlocation(attacker)
        xx,yy,zz = es.getplayerlocation(userid)
        wcs.effect.BeamCustom('#a', '0', 'sprites/lgtning.vmt', x, y, z + 20, xx, yy, zz + 20, 0.5, 40, 40, 0, random.randint(128, 255), random.randint(1, 127), alpha)
        player = wcs.Command(attacker)
        amount = int(round(dmg * vampiric * (int(vampiricPercent) * .01) ) )
        player.Heal(amount)
        es.tell(attacker, '#multi', text('vampiric aura', {'health':amount, 'player':es.getplayername(userid)}, playerlib.getPlayer(userid).get("lang") ) )
        
def player_ultimate_on(ev):
    userid = ev['userid']
    bomberLevel = wcs.GetLevel(userid, RaceName, 'Suicide Bomber')
    if bomberLevel:
        wcs.Command(userid).UpdateDict('BombDamage', 0)
        increaseDamage(userid)
		
def increaseDamage(userid):
    a = wcs.Command(userid).ReturnDict('BombDamage')
    if a < 20:
        wcs.Command(userid).ModDict('BombDamage', 1)
        wcs.Command(userid).HudHint("%s\n%s" % (text('power', lang=playerlib.getPlayer(userid).get("lang") ), '|' * a) )
        es.emitsound('player', userid, 'buttons/blip2.wav', 0.5, 0.5)
    else:
        wcs.Command(userid).HudHint("%s\n%s" % (text('power', lang=playerlib.getPlayer(userid).get("lang") ), text('maxed', lang=playerlib.getPlayer(userid).get("lang") ) ) )
    wcs.Command(userid).Delayed(0.5, increaseDamage, userid, True, 'undead_%s'%userid)
    
def player_ultimate_off(ev):
    userid = ev['userid']
    player = wcs.Command(userid)
    player.CancelDelayed('undead_%s'%userid)
    bomberLevel = wcs.GetLevel(userid, RaceName, 'Suicide Bomber')
    if bomberLevel:
        damageval = player.ReturnDict('BombDamage')
        team      = ('#t' if ev['es_userteam'] == '3' else '#c')
        distance  = bomberLevel     * int(bomberSuicideDistance) * (damageval /5.)
        damage    = int(bomberLevel * int(bomberSuicideDamage)   * (damageval / 5.))
        player.AreaDamage(team, distance, damage, userid)
        sound = 'weapons/%s' % random.choice(['explode3.wav','explode4.wav','explode5.wav','mortar/mortar_explode1.wav','mortar/mortar_explode2.wav','mortar/mortar_explode3.wav'])
        wcs.effect.Smoke(userid)
        es.emitsound('player', userid, sound, 1.0, damageval / 20.)
        es.server.queuecmd('est_slay %s'%userid)
        player.UpdateDict('BombDamage',0)
